/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.ui.CVSCompareEditorInput;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteCompareOperation;
import org.eclipse.ui.IWorkbenchPage;

public class CompareRemoteResourcesAction
extends CVSAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSRemoteResource[] editions = this.getSelectedRemoteResources();
        if (editions == null || editions.length != 2) {
            MessageDialog.openError((Shell)this.getShell(), (String)Policy.bind("CompareRemoteResourcesAction.unableToCompare"), (String)Policy.bind("CompareRemoteResourcesAction.selectTwoResources"));
            return;
        }
        try {
            if (this.isSameFolder(editions)) {
                new RemoteCompareOperation(null, editions[0], RemoteCompareOperation.getTag(editions[1])).run();
            } else {
                ResourceEditionNode left = new ResourceEditionNode(editions[0]);
                ResourceEditionNode right = new ResourceEditionNode(editions[1]);
                CompareUI.openCompareEditorOnPage((CompareEditorInput)new CVSCompareEditorInput(left, right), (IWorkbenchPage)this.getTargetPage());
            }
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected boolean isSameFolder(ICVSRemoteResource[] editions) {
        return editions[0].isContainer() && editions[0].getRepository().equals(editions[1].getRepository()) && editions[0].getRepositoryRelativePath().equals(editions[1].getRepositoryRelativePath());
    }

    protected boolean isEnabled() throws TeamException {
        ICVSRemoteResource[] resources = this.getSelectedRemoteResources();
        if (resources.length != 2) {
            return false;
        }
        if (resources[0].isContainer() != resources[1].isContainer()) {
            return false;
        }
        return !resources[0].isContainer() || this.isSameFolder(resources);
    }
}

