/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.MyEntityResolver;
import org.apache.jasper.compiler.MyErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_XML = "%=";
    private static final String CLOSE_EXPR_XML = "%";
    private static ErrorHandler errorHandler = new MyErrorHandler();
    private static EntityResolver entityResolver = new MyEntityResolver();

    public static char[] removeQuotes(char[] chars) {
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%' && chars[i + 1] == '\\' && chars[i + 2] == '\\' && chars[i + 3] == '>') {
                caw.write(37);
                caw.write(62);
                i += 3;
                continue;
            }
            caw.write(chars[i]);
        }
        return caw.toCharArray();
    }

    public static char[] escapeQuotes(char[] chars) {
        int n;
        String s = new String(chars);
        while ((n = s.indexOf("%\\>")) >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, n));
            sb.append(CLOSE_EXPR);
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        chars = s.toCharArray();
        return chars;
    }

    public static boolean isExpression(String token, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (isXml) {
            openExpr = OPEN_EXPR_XML;
            closeExpr = CLOSE_EXPR_XML;
        } else {
            openExpr = OPEN_EXPR;
            closeExpr = CLOSE_EXPR;
        }
        return token.startsWith(openExpr) && token.endsWith(closeExpr);
    }

    public static String getExpr(String expression, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (isXml) {
            openExpr = OPEN_EXPR_XML;
            closeExpr = CLOSE_EXPR_XML;
        } else {
            openExpr = OPEN_EXPR;
            closeExpr = CLOSE_EXPR;
        }
        int length = expression.length();
        String returnString = expression.startsWith(openExpr) && expression.endsWith(closeExpr) ? expression.substring(openExpr.length(), length - closeExpr.length()) : "";
        return returnString;
    }

    public static String getExprInXml(String expression) {
        int length = expression.length();
        String returnString = expression.startsWith(OPEN_EXPR) && expression.endsWith(CLOSE_EXPR) ? expression.substring(1, length - 1) : expression;
        return JspUtil.escapeXml(returnString);
    }

    public static Document parseXMLDoc(String uri, InputStream in) throws JasperException {
        return JspUtil.parseXMLDocJaxp(uri, in);
    }

    public static Document parseXMLDocJaxp(String uri, InputStream in) throws JasperException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setValidating(true);
            docFactory.setNamespaceAware(true);
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            builder.setEntityResolver(entityResolver);
            builder.setErrorHandler(errorHandler);
            Document doc = builder.parse(in);
            return doc;
        }
        catch (ParserConfigurationException ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml", (Object[])new Object[]{uri, ex.getMessage()}));
        }
        catch (SAXParseException ex) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml.line", (Object[])new Object[]{uri, new Integer(ex.getLineNumber()), new Integer(ex.getColumnNumber()), ex.getMessage()}));
        }
        catch (SAXException sx) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml", (Object[])new Object[]{uri, sx.getMessage()}));
        }
        catch (IOException io) {
            throw new JasperException(Constants.getString((String)"jsp.error.parse.xml", (Object[])new Object[]{uri, io.toString()}));
        }
    }

    public static void checkAttributes(String typeOfTag, Attributes attrs, ValidAttribute[] validAttributes, Mark start, ErrorDispatcher err) throws JasperException {
        int attrLeftLength;
        boolean valid = true;
        int tempLength = attrs.getLength();
        Vector<String> temp = new Vector<String>(tempLength, 1);
        for (int i = 0; i < tempLength; ++i) {
            String qName = attrs.getQName(i);
            if (qName.equals("xmlns") || qName.startsWith("xmlns:")) continue;
            temp.addElement(qName);
        }
        String missingAttribute = null;
        for (int i = 0; i < validAttributes.length; ++i) {
            if (!validAttributes[i].mandatory) continue;
            int attrPos = temp.indexOf(validAttributes[i].name);
            if (attrPos != -1) {
                temp.remove(attrPos);
                valid = true;
                continue;
            }
            valid = false;
            missingAttribute = validAttributes[i].name;
            break;
        }
        if (!valid) {
            err.jspError(start, "jsp.error.mandatory.attribute", typeOfTag, missingAttribute);
        }
        if ((attrLeftLength = temp.size()) == 0) {
            return;
        }
        String attribute = null;
        for (int j = 0; j < attrLeftLength; ++j) {
            valid = false;
            attribute = (String)temp.elementAt(j);
            for (int i = 0; i < validAttributes.length; ++i) {
                if (!attribute.equals(validAttributes[i].name)) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            err.jspError(start, "jsp.error.invalid.attribute", typeOfTag, attribute);
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        String escString = "";
        String shellSpChars = "\\\"";
        for (int index = 0; index < unescString.length(); ++index) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escString = escString + "\\";
            }
            escString = escString + nextChar;
        }
        return escString;
    }

    public static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String replace(String name, char replace, String with) {
        StringBuffer buf = new StringBuffer();
        int begin = 0;
        int last = name.length();
        while (true) {
            int end;
            if ((end = name.indexOf(replace, begin)) < 0) {
                end = last;
            }
            buf.append(name.substring(begin, end));
            if (end == last) break;
            buf.append(with);
            begin = end + 1;
        }
        return buf.toString();
    }

    public static Hashtable attrsToHashtable(Attributes attrs) {
        int len = attrs.getLength();
        Hashtable<String, String> table = new Hashtable<String, String>(len);
        for (int i = 0; i < len; ++i) {
            table.put(attrs.getQName(i), attrs.getValue(i));
        }
        return table;
    }

    public static String getElementChildTextData(Element e) {
        String s = null;
        Text t = (Text)e.getFirstChild();
        if (t != null && (s = t.getData()) != null) {
            s = s.trim();
        }
        return s;
    }

    public static boolean booleanValue(String s) {
        boolean b = false;
        if (s != null) {
            b = s.equalsIgnoreCase("yes") ? true : Boolean.valueOf(s);
        }
        return b;
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String name, boolean mandatory) {
            this.name = name;
            this.mandatory = mandatory;
        }

        public ValidAttribute(String name) {
            this(name, false);
        }
    }
}

