/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.internal.ImageFactory;
import org.eclipse.ui.views.markers.internal.Messages;

public class ActionOpenMarker
extends SelectionProviderAction {
    private final String IMAGE_PATH = "elcl16/gotoobj_tsk.gif";
    private final String DISABLED_IMAGE_PATH = "dlcl16/gotoobj_tsk.gif";
    protected IWorkbenchPart part;

    public ActionOpenMarker(IWorkbenchPart part, ISelectionProvider provider) {
        super(provider, Messages.getString("openAction.title"));
        this.part = part;
        this.setImageDescriptor(ImageFactory.getImageDescriptor("elcl16/gotoobj_tsk.gif"));
        this.setDisabledImageDescriptor(ImageFactory.getImageDescriptor("dlcl16/gotoobj_tsk.gif"));
        this.setEnabled(false);
    }

    public void run() {
        IEditorInput input;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (!(obj instanceof IMarker)) {
            return;
        }
        IMarker marker = (IMarker)obj;
        IEditorPart editor = this.part.getSite().getPage().getActiveEditor();
        if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            if (marker.getResource().equals(file)) {
                this.part.getSite().getPage().activate((IWorkbenchPart)editor);
            }
        }
        if (marker.getResource() instanceof IFile) {
            try {
                IDE.openEditor(this.part.getSite().getPage(), marker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException e) {
                CoreException nestedException = null;
                IStatus status = e.getStatus();
                if (status != null && status.getException() instanceof CoreException) {
                    nestedException = (CoreException)status.getException();
                }
                if (nestedException != null) {
                    ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.getString("OpenMarker.errorTitle"), (String)e.getMessage(), (IStatus)nestedException.getStatus());
                }
                MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.getString("OpenMarker.errorTitle"), (String)e.getMessage());
            }
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection != null && selection.size() == 1);
    }
}

