/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClass;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHint;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSourceModifier;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class NLSRefactoring
extends Refactoring {
    public static final String BUNDLE_NAME = "BUNDLE_NAME";
    public static final String PROPERTY_FILE_EXT = ".properties";
    public static final String DEFAULT_ACCESSOR_CLASSNAME = "Messages";
    public static final String KEY = "${key}";
    public static final String DEFAULT_SUBST_PATTERN = "getString(${key})";
    private static final String DEFAULT_PROPERTY_FILENAME = "messages";
    private String fAccessorClassName;
    private IPackageFragment fAccessorClassPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private String fSubstitutionPattern;
    private ICompilationUnit fCu;
    private NLSSubstitution[] fSubstitutions;
    private String fPrefix;

    private NLSRefactoring(ICompilationUnit cu) {
        Assert.isNotNull(cu);
        this.fCu = cu;
        String cuName = cu.getElementName();
        this.setPrefix(cuName.substring(0, cuName.length() - 4));
        CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)cu, true, null);
        NLSHint nlsHint = new NLSHint(cu, astRoot);
        this.fSubstitutions = nlsHint.getSubstitutions();
        this.setAccessorClassName(nlsHint.getAccessorClassName());
        this.setAccessorClassPackage(nlsHint.getAccessorClassPackage());
        this.setResourceBundleName(nlsHint.getResourceBundleName());
        this.setResourceBundlePackage(nlsHint.getResourceBundlePackage());
        this.fSubstitutionPattern = NLSRefactoring.getDefaultSubstitutionPattern();
    }

    public static NLSRefactoring create(ICompilationUnit cu) {
        if (!NLSRefactoring.isAvailable(cu)) {
            return null;
        }
        return new NLSRefactoring(cu);
    }

    public static boolean isAvailable(ICompilationUnit cu) {
        if (cu == null) {
            return false;
        }
        return cu.exists();
    }

    public void setSubstitutionPattern(String pattern) {
        Assert.isNotNull(pattern);
        this.fSubstitutionPattern = pattern;
    }

    public String getSubstitutionPattern() {
        return this.fSubstitutionPattern;
    }

    public static String getDefaultSubstitutionPattern() {
        return DEFAULT_SUBST_PATTERN;
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public String getName() {
        return NLSMessages.getFormattedString("NLSRefactoring.compilation_unit", this.fCu.getElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fSubstitutions.length == 0) {
            String message = NLSMessages.getFormattedString("NLSRefactoring.no_strings", this.fCu.getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        this.checkParameters();
        try {
            pm.beginTask(NLSMessages.getString("NLSRefactoring.checking"), 5);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkIfAnythingToDo());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.validateModifiesFiles());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkSubstitutionPattern());
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            result.merge(this.checkKeys());
            pm.worked(1);
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!this.propertyFileExists() && this.willModifyPropertyFile()) {
                String msg = NLSMessages.getFormattedString("NLSRefactoring.will_be_created", this.getPropertyFilePath().toString());
                result.addInfo(msg);
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            this.checkParameters();
            pm.beginTask("", 3);
            DynamicValidationStateChange result = new DynamicValidationStateChange("NLS Refactoring");
            if (this.willCreateAccessorClass()) {
                result.add(AccessorClass.create(this.fCu, this.fAccessorClassName, this.getAccessorCUPath(), this.fAccessorClassPackage, this.getPropertyFilePath(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            pm.worked(1);
            if (this.willModifySource()) {
                result.add(NLSSourceModifier.create(this.getCu(), this.fSubstitutions, this.fSubstitutionPattern, this.fAccessorClassPackage, this.fAccessorClassName));
            }
            pm.worked(1);
            if (this.willModifyPropertyFile()) {
                result.add(NLSPropertyFileModifier.create(this.fSubstitutions, this.getPropertyFilePath()));
            }
            pm.worked(1);
            DynamicValidationStateChange dynamicValidationStateChange = result;
            return dynamicValidationStateChange;
        }
        finally {
            pm.done();
        }
    }

    private void checkParameters() {
        Assert.isNotNull(this.fSubstitutions);
        Assert.isNotNull(this.fAccessorClassPackage);
        Assert.isNotNull(this.fAccessorClassName);
        Assert.isNotNull(this.fSubstitutionPattern);
    }

    private IFile[] getAllFilesToModify() {
        IFile file;
        IResource resource;
        ArrayList<Object> files = new ArrayList<Object>(2);
        if (this.willModifySource() && (resource = this.fCu.getResource()).exists()) {
            files.add(resource);
        }
        if (this.willModifyPropertyFile() && (file = this.getPropertyFileHandle()).exists()) {
            files.add(file);
        }
        return files.toArray(new IFile[files.size()]);
    }

    public IFile getPropertyFileHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getPropertyFilePath());
    }

    public IPath getPropertyFilePath() {
        return this.fResourceBundlePackage.getPath().append(this.fResourceBundleName);
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext());
    }

    private RefactoringStatus checkIfAnythingToDo() throws JavaModelException {
        if (this.willCreateAccessorClass()) {
            return null;
        }
        if (this.willModifyPropertyFile()) {
            return null;
        }
        if (this.willModifySource()) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.addFatalError(NLSMessages.getString("NLSRefactoring.nothing_to_do"));
        return result;
    }

    private boolean propertyFileExists() {
        return this.getPropertyFileHandle().exists();
    }

    private RefactoringStatus checkSubstitutionPattern() {
        String msg;
        String pattern = this.getSubstitutionPattern();
        RefactoringStatus result = new RefactoringStatus();
        if (pattern.trim().length() == 0) {
            result.addError(NLSMessages.getString("NLSRefactoring.pattern_empty"));
        }
        if (pattern.indexOf(KEY) == -1) {
            msg = NLSMessages.getFormattedString("NLSRefactoring.pattern_does_not_contain", KEY);
            result.addWarning(msg);
        }
        if (pattern.indexOf(KEY) != pattern.lastIndexOf(KEY)) {
            msg = NLSMessages.getFormattedString("NLSRefactoring.Only_the_first_occurrence_of", KEY);
            result.addWarning(msg);
        }
        return result;
    }

    private RefactoringStatus checkKeys() {
        RefactoringStatus result = new RefactoringStatus();
        NLSSubstitution[] subs = this.fSubstitutions;
        for (int i = 0; i < subs.length; ++i) {
            NLSSubstitution substitution = subs[i];
            if (substitution.getState() != 0 || !substitution.hasStateChanged()) continue;
            result.merge(NLSRefactoring.checkKey(substitution.getKey()));
        }
        return result;
    }

    private static RefactoringStatus checkKey(String key) {
        RefactoringStatus result = new RefactoringStatus();
        if (key == null) {
            result.addFatalError(NLSMessages.getString("NLSRefactoring.null"));
        }
        if (key.startsWith("!") || key.startsWith("#")) {
            JavaStringStatusContext context = new JavaStringStatusContext(key, new SourceRange(0, 0));
            result.addWarning(NLSMessages.getString("NLSRefactoring.warning"), (RefactoringStatusContext)context);
        }
        if ("".equals(key.trim())) {
            result.addFatalError(NLSMessages.getString("NLSRefactoring.empty"));
        }
        String[] UNWANTED_STRINGS = new String[]{" ", ":", "\"", "\\", "'", "?", "="};
        for (int i = 0; i < UNWANTED_STRINGS.length; ++i) {
            if (key.indexOf(UNWANTED_STRINGS[i]) == -1) continue;
            String[] args = new String[]{key, UNWANTED_STRINGS[i]};
            String msg = NLSMessages.getFormattedString("NLSRefactoring.should_not_contain", args);
            result.addError(msg);
        }
        return result;
    }

    private boolean willCreateAccessorClass() throws JavaModelException {
        NLSSubstitution[] subs = this.fSubstitutions;
        if (NLSSubstitution.countItems(subs, 0) == 0) {
            return false;
        }
        ICompilationUnit compilationUnit = this.getAccessorCu();
        if (compilationUnit.exists()) {
            return false;
        }
        if (this.typeNameExistsInPackage(this.fAccessorClassPackage, this.fAccessorClassName)) {
            return false;
        }
        return !Checks.resourceExists(this.getAccessorCUPath());
    }

    private ICompilationUnit getAccessorCu() {
        return this.fAccessorClassPackage.getCompilationUnit(this.getAccessorCUName());
    }

    private boolean willModifySource() {
        NLSSubstitution[] subs = this.fSubstitutions;
        for (int i = 0; i < subs.length; ++i) {
            if (!subs[i].hasSourceChange()) continue;
            return true;
        }
        return false;
    }

    private boolean willModifyPropertyFile() {
        NLSSubstitution[] subs = this.fSubstitutions;
        for (int i = 0; i < subs.length; ++i) {
            NLSSubstitution substitution = subs[i];
            if (!substitution.hasPropertyFileChange()) continue;
            return true;
        }
        return false;
    }

    private boolean typeNameExistsInPackage(IPackageFragment pack, String name) throws JavaModelException {
        return Checks.findTypeInPackage(pack, name) != null;
    }

    private String getAccessorCUName() {
        return this.fAccessorClassName + ".java";
    }

    private IPath getAccessorCUPath() {
        IPath res = this.fAccessorClassPackage.getPath().append(this.getAccessorCUName());
        return res;
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }

    public String getPrefix() {
        return this.fPrefix;
    }

    public void setPrefix(String prefix) {
        this.fPrefix = prefix;
        NLSSubstitution.setPrefix(prefix);
    }

    public static String getDefaultPropertiesFilename() {
        return "messages.properties";
    }

    public void setAccessorClassName(String name) {
        Assert.isNotNull(name);
        this.fAccessorClassName = name;
    }

    public void setAccessorClassPackage(IPackageFragment packageFragment) {
        Assert.isNotNull(packageFragment);
        this.fAccessorClassPackage = packageFragment;
    }

    public void setResourceBundlePackage(IPackageFragment resourceBundlePackage) {
        Assert.isNotNull(resourceBundlePackage);
        this.fResourceBundlePackage = resourceBundlePackage;
    }

    public void setResourceBundleName(String resourceBundleName) {
        Assert.isNotNull(resourceBundleName);
        this.fResourceBundleName = resourceBundleName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorClassPackage;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public String getAccessorClassName() {
        return this.fAccessorClassName;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }
}

