/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Comparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;

public class JavaCompletionProposalComparator
implements Comparator {
    private static JavaCompletionProposalComparator fgInstance = new JavaCompletionProposalComparator();
    private boolean fOrderAlphabetically = false;

    public static JavaCompletionProposalComparator getInstance() {
        return fgInstance;
    }

    public void setOrderAlphabetically(boolean orderAlphabetically) {
        this.fOrderAlphabetically = orderAlphabetically;
    }

    public int compare(Object o1, Object o2) {
        ICompletionProposal p1 = (ICompletionProposal)o1;
        ICompletionProposal p2 = (ICompletionProposal)o2;
        if (!this.fOrderAlphabetically) {
            int r1 = this.getRelevance(p1);
            int r2 = this.getRelevance(p2);
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
        }
        return p1.getDisplayString().compareToIgnoreCase(p2.getDisplayString());
    }

    private int getRelevance(ICompletionProposal obj) {
        if (obj instanceof IJavaCompletionProposal) {
            IJavaCompletionProposal jcp = (IJavaCompletionProposal)obj;
            return jcp.getRelevance();
        }
        if (obj instanceof TemplateProposal) {
            TemplateProposal tp = (TemplateProposal)obj;
            return tp.getRelevance();
        }
        return 0;
    }
}

