/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor.items;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import vlcskineditor.Bezier;
import vlcskineditor.Item;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.ItemAddEvent;
import vlcskineditor.history.SliderEditEvent;
import vlcskineditor.items.SliderBackground;

public class Slider
extends Item
implements ActionListener {
    public final String DOWN_DEFAULT = "none";
    public final String OVER_DEFAULT = "none";
    public final int THICKNESS_DEFAULT = 10;
    public final String VALUE_DEFAULT = "none";
    public final String TOOLTIPTEXT_DEFAULT = "none";
    public String up;
    public String down = "none";
    public String over = "none";
    public String points = "(0,0)";
    public int thickness = 10;
    public String value = "none";
    public String tooltiptext = "none";
    public SliderBackground sbg = null;
    boolean inPlaytree = false;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField help_tf;
    JTextField visible_tf;
    JTextField up_tf;
    JTextField down_tf;
    JTextField over_tf;
    JTextField points_tf;
    JTextField thickness_tf;
    JTextField tooltiptext_tf;
    JComboBox lefttop_cb;
    JComboBox rightbottom_cb;
    JComboBox xkeepratio_cb;
    JComboBox ykeepratio_cb;
    JComboBox resize_cb;
    JComboBox action_cb;
    JComboBox value_cb;
    JCheckBox sbg_chb;
    JButton visible_btn;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    JButton sbg_btn;
    Bezier b;
    int[] xpos;
    int[] ypos;

    public Slider(String string, Skin skin) {
        this.type = "Slider";
        this.s = skin;
        String[] stringArray = string.split("\n");
        this.up = XML.getValue(stringArray[0], "up");
        if (stringArray[0].indexOf(" down=\"") != -1) {
            this.down = XML.getValue(stringArray[0], "down");
        }
        if (stringArray[0].indexOf(" over=\"") != -1) {
            this.over = XML.getValue(stringArray[0], "over");
        }
        this.points = XML.getValue(stringArray[0], "points");
        this.updateBezier();
        if (stringArray[0].indexOf(" thickness=\"") != -1) {
            this.thickness = XML.getIntValue(stringArray[0], "thickness");
        }
        if (stringArray[0].indexOf(" value=\"") != -1) {
            this.value = XML.getValue(stringArray[0], "value");
        }
        if (stringArray[0].indexOf(" tooltiptext=\"") != -1) {
            this.tooltiptext = XML.getValue(stringArray[0], "tooltiptext");
        }
        if (stringArray[0].indexOf(" x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf(" y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf(" id=\"") != -1 ? XML.getValue(stringArray[0], "id") : "Unnamed slider #" + this.s.getNewId();
        if (stringArray[0].indexOf(" lefttop=\"") != -1) {
            this.lefttop = XML.getValue(stringArray[0], "lefttop");
        }
        if (stringArray[0].indexOf(" rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(stringArray[0], "rightbottom");
        }
        if (stringArray[0].indexOf(" xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "xkeepratio");
        }
        if (stringArray[0].indexOf(" ykeepratio=\"") != -1) {
            this.ykeepratio = XML.getBoolValue(stringArray[0], "ykeepratio");
        }
        if (string.indexOf(" visible=\"") != -1) {
            this.visible = XML.getValue(string, "visible");
        }
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].startsWith("<!--")) {
                    while (stringArray[i].indexOf("-->") == -1) {
                        ++i;
                    }
                    continue;
                }
                if (!stringArray[i].startsWith("<SliderBackground")) continue;
                this.sbg = new SliderBackground(stringArray[i], this.s);
                break;
            }
        }
        this.created = true;
    }

    public Slider(String string, Skin skin, boolean bl) {
        this.type = "Slider";
        this.s = skin;
        String[] stringArray = string.split("\n");
        this.inPlaytree = bl;
        this.up = XML.getValue(stringArray[0], "up");
        if (stringArray[0].indexOf("down=\"") != -1) {
            this.down = XML.getValue(stringArray[0], "down");
        }
        if (stringArray[0].indexOf("over=\"") != -1) {
            this.over = XML.getValue(stringArray[0], "over");
        }
        this.points = XML.getValue(stringArray[0], "points");
        this.updateBezier();
        if (stringArray[0].indexOf("thickness=\"") != -1) {
            this.thickness = XML.getIntValue(stringArray[0], "thickness");
        }
        if (stringArray[0].indexOf("tooltiptext=\"") != -1) {
            this.tooltiptext = XML.getValue(stringArray[0], "tooltiptext");
        }
        if (stringArray[0].indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : "Unnamed slider #" + this.s.getNewId();
        if (stringArray[0].indexOf("lefttop=\"") != -1) {
            this.lefttop = XML.getValue(stringArray[0], "lefttop");
        }
        if (stringArray[0].indexOf("rightbottom=\"") != -1) {
            this.rightbottom = XML.getValue(stringArray[0], "rightbottom");
        }
        if (stringArray[0].indexOf("xkeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "xkeepratio");
        }
        if (stringArray[0].indexOf("ykeepratio=\"") != -1) {
            this.xkeepratio = XML.getBoolValue(stringArray[0], "ykeepratio");
        }
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("<SliderBackground")) continue;
                this.sbg = new SliderBackground(stringArray[i], this.s);
                break;
            }
        }
        this.created = true;
    }

    public Slider(Skin skin) {
        this.type = "Slider";
        this.s = skin;
        this.up = "none";
        this.id = "Unnamed slider #" + this.s.getNewId();
        this.updateBezier();
        this.showOptions();
        this.s.updateItems();
        this.s.expandItem(this.id);
    }

    public Slider(Skin skin, boolean bl) {
        this.type = "Slider";
        this.s = skin;
        this.up = "none";
        this.id = "Unnamed slider #" + this.s.getNewId();
        this.inPlaytree = bl;
        this.created = true;
    }

    public void updateBezier() {
        String[] stringArray = this.points.split("\\),\\(");
        this.xpos = new int[stringArray.length];
        this.ypos = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = string.split(",");
            this.xpos[i] = Integer.parseInt(stringArray2[0].replaceAll("\\(", "").trim());
            this.ypos[i] = Integer.parseInt(stringArray2[1].replaceAll("\\)", "").trim());
        }
        this.b = new Bezier(this.xpos, this.ypos, 0);
    }

    @Override
    public void update() {
        if (!this.created) {
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up = this.up_tf.getText();
            this.over = this.over_tf.getText();
            this.down = this.down_tf.getText();
            this.points = this.points_tf.getText();
            this.thickness = Integer.parseInt(this.thickness_tf.getText());
            if (!this.inPlaytree) {
                this.value = (String)this.value_cb.getSelectedItem();
            }
            this.tooltiptext = this.tooltiptext_tf.getText();
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            this.created = true;
            this.frame.setDefaultCloseOperation(1);
            ItemAddEvent itemAddEvent = new ItemAddEvent(this.s.getParentListOf(this.id), this);
            this.s.m.hist.addEvent(itemAddEvent);
        } else {
            SliderEditEvent sliderEditEvent = new SliderEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.lefttop = this.lefttop_cb.getSelectedItem().toString();
            this.rightbottom = this.rightbottom_cb.getSelectedItem().toString();
            this.xkeepratio = Boolean.parseBoolean(this.xkeepratio_cb.getSelectedItem().toString());
            this.ykeepratio = Boolean.parseBoolean(this.ykeepratio_cb.getSelectedItem().toString());
            this.visible = this.visible_tf.getText();
            this.help = this.help_tf.getText();
            this.up = this.up_tf.getText();
            this.over = this.over_tf.getText();
            this.down = this.down_tf.getText();
            this.points = this.points_tf.getText();
            this.thickness = Integer.parseInt(this.thickness_tf.getText());
            if (!this.inPlaytree) {
                this.value = (String)this.value_cb.getSelectedItem();
            }
            this.tooltiptext = this.tooltiptext_tf.getText();
            this.updateBezier();
            this.s.updateItems();
            this.s.expandItem(this.id);
            sliderEditEvent.setNew();
            this.s.m.hist.addEvent(sliderEditEvent);
        }
    }

    @Override
    public void showOptions() {
        if (this.frame == null) {
            Object object;
            this.frame = new JFrame("Slider settings");
            this.frame.setResizable(false);
            this.frame.setLayout(new FlowLayout());
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel("ID*:");
            this.id_tf = new JTextField();
            JLabel jLabel2 = new JLabel("X:");
            this.x_tf = new JTextField();
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel("Y:");
            this.y_tf = new JTextField();
            this.y_tf.setDocument(new NumbersOnlyDocument());
            String[] stringArray = new String[]{"lefttop", "leftbottom", "righttop", "rightbottom"};
            JLabel jLabel4 = new JLabel("Lefttop:");
            this.lefttop_cb = new JComboBox<String>(stringArray);
            this.lefttop_cb.setToolTipText("Indicate to which corner of the Layout the top-left-hand corner of this item is attached, in case of resizing.");
            JLabel jLabel5 = new JLabel("Rightbottom:");
            this.rightbottom_cb = new JComboBox<String>(stringArray);
            this.rightbottom_cb.setToolTipText("Indicate to which corner of the Layout the bottom-right-hand corner of this item is attached, in case of resizing.");
            Object[] objectArray = new Object[]{true, false};
            JLabel jLabel6 = new JLabel("Keep X Ratio:");
            this.xkeepratio_cb = new JComboBox<Object>(objectArray);
            this.xkeepratio_cb.setToolTipText("When set to true, the behaviour of the horizontal resizing is changed. For example, if initially the space to the left of the control is twice as big as the one to its right, this will stay the same during any horizontal resizing. The width of the control stays constant.");
            JLabel jLabel7 = new JLabel("Keep Y Ratio:");
            this.ykeepratio_cb = new JComboBox<Object>(objectArray);
            this.ykeepratio_cb.setToolTipText("When set to true, the behaviour of the vertical resizing is changed. For example, if initially the space to the top of the control is twice as big as the one to its bottom, this will stay the same during any vertical resizing. The height of the control stays constant.");
            JLabel jLabel8 = new JLabel("Visibility:");
            this.visible_tf = new JTextField();
            this.visible_btn = new JButton("", this.s.m.help_icon);
            this.visible_btn.addActionListener(this);
            JLabel jLabel9 = new JLabel("Help Text:");
            this.help_tf = new JTextField();
            this.help_tf.setToolTipText("Help text for the current control. The variable '$H' will be expanded to this value when the mouse hovers the current control.");
            JLabel jLabel10 = new JLabel("Normal image*:");
            this.up_tf = new JTextField();
            JLabel jLabel11 = new JLabel("Mouse-over image:");
            this.over_tf = new JTextField();
            JLabel jLabel12 = new JLabel("Mouse-click image:");
            this.down_tf = new JTextField();
            JLabel jLabel13 = new JLabel("Points*:");
            this.points_tf = new JTextField();
            JLabel jLabel14 = new JLabel("Thickness:");
            this.thickness_tf = new JTextField();
            this.thickness_tf.setToolTipText("Thickness of the slider curve. This attribute is used to determine whether the mouse is over the slider (hence whether a mouse click will have an effect on the cursor position).");
            JLabel jLabel15 = new JLabel("Value*:");
            if (this.inPlaytree) {
                object = new String[]{"Playtree scrolling"};
                this.value_cb = new JComboBox<String>((E[])object);
            } else {
                object = new String[]{"time", "volume", "equalizer.preamp", "equalizer.band(0)", "equalizer.band(1)", "equalizer.band(2)", "equalizer.band(3)", "equalizer.band(4)", "equalizer.band(5)", "equalizer.band(6)", "equalizer.band(7)", "equalizer.band(8)", "equalizer.band(9)"};
                this.value_cb = new JComboBox<String>((E[])object);
            }
            object = new JLabel("Tooltiptext:");
            this.tooltiptext_tf = new JTextField();
            this.sbg_chb = new JCheckBox("Enable Background");
            this.sbg_chb.addActionListener(this);
            this.sbg_btn = new JButton("Edit...");
            this.sbg_btn.addActionListener(this);
            this.ok_btn = new JButton("OK");
            this.ok_btn.addActionListener(this);
            this.ok_btn.setPreferredSize(new Dimension(70, 25));
            this.cancel_btn = new JButton("Cancel");
            this.cancel_btn.addActionListener(this);
            this.cancel_btn.setPreferredSize(new Dimension(70, 25));
            this.help_btn = new JButton("Help");
            this.help_btn.addActionListener(this);
            this.help_btn.setPreferredSize(new Dimension(70, 25));
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            jLabel.setBounds(5, 15, 75, 24);
            this.id_tf.setBounds(85, 15, 150, 24);
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            jLabel2.setBounds(5, 45, 75, 24);
            this.x_tf.setBounds(85, 45, 150, 24);
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            jLabel3.setBounds(5, 75, 75, 24);
            this.y_tf.setBounds(85, 75, 150, 24);
            jPanel.add(jLabel4);
            jPanel.add(this.lefttop_cb);
            jLabel4.setBounds(5, 105, 75, 24);
            this.lefttop_cb.setBounds(85, 105, 150, 24);
            jPanel.add(jLabel5);
            jPanel.add(this.rightbottom_cb);
            jLabel5.setBounds(5, 135, 75, 24);
            this.rightbottom_cb.setBounds(85, 135, 150, 24);
            jPanel.add(jLabel6);
            jPanel.add(this.xkeepratio_cb);
            jLabel6.setBounds(5, 165, 75, 24);
            this.xkeepratio_cb.setBounds(85, 165, 150, 24);
            jPanel.add(jLabel7);
            jPanel.add(this.ykeepratio_cb);
            jLabel7.setBounds(5, 195, 75, 24);
            this.ykeepratio_cb.setBounds(85, 195, 150, 24);
            jPanel.add(jLabel8);
            jPanel.add(this.visible_tf);
            jPanel.add(this.visible_btn);
            jLabel8.setBounds(5, 225, 75, 24);
            this.visible_tf.setBounds(85, 225, 120, 24);
            this.visible_btn.setBounds(210, 225, 24, 24);
            jPanel.add(jLabel9);
            jPanel.add(this.help_tf);
            jLabel9.setBounds(5, 255, 75, 24);
            this.help_tf.setBounds(85, 255, 150, 24);
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "General Attributes"));
            jPanel.setMinimumSize(new Dimension(240, 285));
            jPanel.setPreferredSize(new Dimension(240, 285));
            jPanel.setMaximumSize(new Dimension(240, 285));
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel10);
            jPanel2.add(this.up_tf);
            jLabel10.setBounds(5, 15, 75, 24);
            this.up_tf.setBounds(85, 15, 150, 24);
            jPanel2.add(jLabel11);
            jPanel2.add(this.over_tf);
            jLabel11.setBounds(5, 45, 75, 24);
            this.over_tf.setBounds(85, 45, 150, 24);
            jPanel2.add(jLabel12);
            jPanel2.add(this.down_tf);
            jLabel12.setBounds(5, 75, 75, 24);
            this.down_tf.setBounds(85, 75, 150, 24);
            jPanel2.add(jLabel13);
            jPanel2.add(this.points_tf);
            jLabel13.setBounds(5, 105, 75, 24);
            this.points_tf.setBounds(85, 105, 150, 24);
            jPanel2.add(jLabel14);
            jPanel2.add(this.thickness_tf);
            jLabel14.setBounds(5, 135, 75, 24);
            this.thickness_tf.setBounds(85, 135, 150, 24);
            jPanel2.add(jLabel15);
            jPanel2.add(this.value_cb);
            jLabel15.setBounds(5, 165, 75, 24);
            this.value_cb.setBounds(85, 165, 150, 24);
            jPanel2.add((Component)object);
            jPanel2.add(this.tooltiptext_tf);
            ((Component)object).setBounds(5, 195, 75, 24);
            this.tooltiptext_tf.setBounds(85, 195, 150, 24);
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Slider Attributes"));
            jPanel2.setMinimumSize(new Dimension(240, 225));
            jPanel2.setPreferredSize(new Dimension(240, 225));
            jPanel2.setMaximumSize(new Dimension(240, 225));
            this.frame.add(jPanel2);
            JPanel jPanel3 = new JPanel(null);
            jPanel3.add(this.sbg_chb);
            jPanel3.add(this.sbg_btn);
            this.sbg_chb.setBounds(5, 15, 150, 24);
            this.sbg_btn.setBounds(160, 15, 75, 24);
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Slider background"));
            jPanel3.setMinimumSize(new Dimension(240, 45));
            jPanel3.setPreferredSize(new Dimension(240, 45));
            jPanel3.setMaximumSize(new Dimension(240, 45));
            this.frame.add(jPanel3);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(new JLabel("* required attribute"));
            this.frame.setMinimumSize(new Dimension(250, 630));
            this.frame.setPreferredSize(new Dimension(250, 630));
            this.frame.setMaximumSize(new Dimension(250, 630));
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.lefttop_cb.setSelectedItem(this.lefttop);
        this.rightbottom_cb.setSelectedItem(this.rightbottom);
        this.xkeepratio_cb.setSelectedItem(this.xkeepratio);
        this.ykeepratio_cb.setSelectedItem(this.ykeepratio);
        this.visible_tf.setText(this.visible);
        this.help_tf.setText(this.help);
        this.up_tf.setText(this.up);
        this.over_tf.setText(this.over);
        this.down_tf.setText(this.down);
        this.thickness_tf.setText(String.valueOf(this.thickness));
        this.points_tf.setText(this.points);
        if (!this.inPlaytree) {
            this.value_cb.setSelectedItem(this.value);
        }
        this.tooltiptext_tf.setText(this.tooltiptext);
        this.sbg_chb.setSelected(this.sbg != null);
        this.sbg_btn.setEnabled(this.sbg != null);
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter a valid ID!", "ID not valid", 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, "The ID \"" + this.id_tf.getText() + "\" already exists, please choose another one.", "ID not valid", 1);
                return;
            }
            if (this.s.getResource(this.up_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.up_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.over_tf.getText().equals("none") && this.s.getResource(this.over_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.over_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (!this.down_tf.getText().equals("none") && this.s.getResource(this.down_tf.getText()) == null) {
                JOptionPane.showMessageDialog(this.frame, "The bitmap \"" + this.down_tf.getText() + "\" does not exist!", "Image not valid", 1);
                return;
            }
            if (this.points_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, "Please enter valid points!", "Points not valid", 1);
                return;
            }
            this.update();
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-slider.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-slider.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.sbg_chb)) {
            if (this.sbg_chb.isSelected()) {
                this.sbg = new SliderBackground(this.s, this);
                this.sbg_btn.setEnabled(true);
            } else {
                this.sbg = null;
                this.sbg_btn.setEnabled(false);
            }
        } else if (actionEvent.getSource().equals(this.sbg_btn)) {
            if (this.sbg != null) {
                this.sbg.showOptions();
            }
        } else if (actionEvent.getSource().equals(this.visible_btn)) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI("http://www.videolan.org/vlc/skinedhlp/i-slider.html"));
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, exception.toString(), exception.getMessage(), 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Could not launch Browser", "Go to the following URL manually:\nhttp://www.videolan.org/vlc/skinedhlp/i-slider.html", 2);
            }
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            List<Item> list;
            if (!this.created && (list = this.s.getParentListOf(this.id)) != null) {
                list.remove(this);
            }
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void removeBG() {
        if (this.sbg == null) {
            return;
        }
        this.sbg = null;
        this.sbg_chb.setSelected(false);
        this.sbg_btn.setEnabled(false);
    }

    @Override
    public String returnCode(String string) {
        String string2 = string + "<Slider";
        if (!this.id.equals("Unnamed")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        string2 = string2 + " points=\"" + this.points + "\"";
        if (this.thickness != 10) {
            string2 = string2 + " thickness=\"" + String.valueOf(this.thickness) + "\"";
        }
        if (!this.value.equals("none")) {
            string2 = string2 + " value=\"" + this.value + "\"";
        }
        if (!this.tooltiptext.equals("none")) {
            string2 = string2 + " tooltiptext=\"" + this.tooltiptext + "\"";
        }
        string2 = string2 + " up=\"" + this.up + "\"";
        if (!this.down.equals("none")) {
            string2 = string2 + " down=\"" + this.down + "\"";
        }
        if (!this.over.equals("none")) {
            string2 = string2 + " over=\"" + this.over + "\"";
        }
        if (!this.lefttop.equals("lefttop")) {
            string2 = string2 + " lefttop=\"" + this.lefttop + "\"";
        }
        if (!this.rightbottom.equals("lefttop")) {
            string2 = string2 + " rightbottom=\"" + this.rightbottom + "\"";
        }
        if (this.xkeepratio) {
            string2 = string2 + " xkeepratio=\"" + String.valueOf(this.xkeepratio) + "\"";
        }
        if (this.ykeepratio) {
            string2 = string2 + " ykeepratio=\"" + String.valueOf(this.ykeepratio) + "\"";
        }
        if (!this.help.equals("")) {
            string2 = string2 + " help=\"" + this.help + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + this.visible + "\"";
        }
        if (this.sbg == null) {
            string2 = string2 + "/>";
        } else {
            string2 = string2 + ">\n" + this.sbg.returnCode(string + Skin.indentation);
            string2 = string2 + "\n" + string + "</Slider>";
        }
        return string2;
    }

    @Override
    public void draw(Graphics2D graphics2D, int n) {
        this.draw(graphics2D, 0, 0, n);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2, int n3) {
        if (!this.created) {
            return;
        }
        this.offsetx = n;
        this.offsety = n2;
        boolean bl = this.s.gvars.parseBoolean(this.visible);
        if (this.sbg != null && bl) {
            this.sbg.draw(graphics2D, this.x + n, this.y + n2, n3);
            this.sbg.setOffset(this.x + this.offsetx, this.y + this.offsety);
        }
        BufferedImage bufferedImage = this.s.getBitmapImage(this.up);
        Point2D.Float float_ = this.b.getPoint(this.s.gvars.getSliderValue());
        if (bl && bufferedImage != null) {
            graphics2D.drawImage(bufferedImage, (int)(float_.getX() + (double)this.x + (double)n - (double)(bufferedImage.getWidth() / 2)) * n3, (int)(float_.getY() + (double)this.y + (double)n2 - (double)(bufferedImage.getHeight() / 2)) * n3, bufferedImage.getWidth() * n3, bufferedImage.getHeight() * n3, null);
        }
        if (this.selected) {
            graphics2D.setColor(Color.RED);
            for (float f = 0.0f; f <= 1.0f; f += 0.1f) {
                Point2D.Float float_2 = this.b.getPoint(f);
                Point2D.Float float_3 = this.b.getPoint(f + 0.1f);
                graphics2D.drawLine((int)(float_2.getX() + (double)this.x + (double)n) * n3, (int)(float_2.getY() + (double)this.y + (double)n2) * n3, (int)(float_3.getX() + (double)this.x + (double)n) * n3, (int)(float_3.getY() + (double)this.y + (double)n2) * n3);
            }
            graphics2D.setColor(Color.YELLOW);
            for (int i = 0; i < this.xpos.length; ++i) {
                graphics2D.fillOval((this.xpos[i] + this.x + n - 1) * n3, (this.ypos[i] + this.y + n2 - 1) * n3, 3, 3);
            }
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        int n3 = this.b.getHeight();
        int n4 = this.b.getWidth();
        return n >= this.x + this.offsetx && n <= this.x + this.offsetx + n4 && n2 >= this.y + this.offsety && n2 <= this.y + this.offsety + n3;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Slider: " + this.id);
        if (this.sbg != null) {
            defaultMutableTreeNode.add(this.sbg.getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    @Override
    public Item getItem(String string) {
        if (this.id.equals(string)) {
            return this;
        }
        if (this.sbg == null) {
            return null;
        }
        if (this.sbg.id.equals(string)) {
            return this.sbg;
        }
        return null;
    }

    @Override
    public Item getParentOf(String string) {
        if (this.sbg != null) {
            if (this.sbg.id.equals(string)) {
                return this;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean uses(String string) {
        return this.sbg != null && this.sbg.uses(string) || this.up.equals(string) || this.over.equals(string) || this.down.equals(string);
    }

    @Override
    public void renameForCopy(String string) {
        String string2 = string;
        super.renameForCopy(string);
        if (this.sbg != null) {
            this.sbg.renameForCopy(string2);
        }
    }
}

